<?php

namespace App\Entities\Courses;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Lesson extends Model 
{

    protected $table = 'lessons';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function module()
    {
        return $this->belongsTo('Module');
    }

    public function course()
    {
        return $this->hasOne('Course');
    }

}